<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "90% ứng viên thành công tìm việc qua vieclamtuvanvien.com",
  "alternateName": "Vieclamtuvanvien",
  "url": "http://vieclamtuvanvien.com/",
  "logo": "https://vieclamtuvanvien.com/wp-content/uploads/elementor/thumbs/vieclamtuvan-qkjwasmhii0edv0ey0juabrytb5cww4gmxwq2se2m6.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0812 464 457",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamtuvanvien/",
    "https://www.youtube.com/channel/UCHyHHVDaMve8oSTt3nHUQXg/about",
    "https://twitter.com/vltuvanvien",
    "https://www.reddit.com/user/vieclamtuvanvien/",
    "https://www.linkedin.com/in/vieclamtuvanvien/",
    "https://vieclamtuvanvien.blogspot.com/",
    "https://www.pinterest.com/vieclamtuvanvien/",
    "https://vieclamtuvanvien.tumblr.com/"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "90% ứng viên thành công tìm việc qua vieclamtuvanvien.com",
  "image": "https://vieclamtuvanvien.com/wp-content/uploads/elementor/thumbs/vieclamtuvan-qkjwasmhii0edv0ey0juabrytb5cww4gmxwq2se2m6.png",
  "@id": "http://vieclamtuvanvien.com/",
  "url": "http://vieclamtuvanvien.com/",
  "telephone": "0812 464 457",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "44 Đ. Trần Đại Nghĩa, Tân Nhựt, Bình Chánh, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.7390176,
    "longitude": 106.5500609
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://sites.google.com/view/vieclamtuvanvien/",
    "https://www.youtube.com/channel/UCHyHHVDaMve8oSTt3nHUQXg/about",
    "https://twitter.com/vltuvanvien",
    "https://www.reddit.com/user/vieclamtuvanvien/",
    "https://www.linkedin.com/in/vieclamtuvanvien/",
    "https://vieclamtuvanvien.blogspot.com/",
    "https://www.pinterest.com/vieclamtuvanvien/",
    "https://vieclamtuvanvien.tumblr.com/"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Phạm Ngọc Long",
  "url": "https://vieclamtuvanvien.com/author/admin/",
  "image": "https://iparty.vn/wp-content/uploads/2022/08/chup-anh-chan-dung-600x900.jpg",
  "sameAs": [
    "https://sites.google.com/view/ceophamngoclong/",
    "https://www.youtube.com/channel/UC8KbsAbc4fJl_r0ib7PfL0g/about",
    "https://twitter.com/pham_ngoclong",
    "https://ceo-phamngoclong.blogspot.com/",
    "https://www.pinterest.com/ceo_phamngoclong/",
    "https://ceophamngoclong.tumblr.com/",
    "https://www.blogger.com/profile/01600749203298816382",
    "https://about.me/phamngoclong/"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "vieclamtuvanvien.com"
  }  
}
</script>
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-RNFRM92233"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-RNFRM92233');
</script>
	<meta name='dmca-site-verification' content='TDJhRE91REVzaWE5RytFYnJsK2tiWGNaZWs1QWR1Y2duMDBFaExxcUdKcz01' />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">